package com.biz.crm.nebular.tpm.budgetsubjects.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 预算科目 返回vo
 *
 * @author huang.long
 * @date 2020-09-09 13:40:31
 */
@Setter
@Getter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "预算科目 ")
@SaturnEntity(name = "TpmBudgetSubjectsRespVo", description = "预算科目 ")
public class TpmBudgetSubjectsRespVo extends CrmExtVo {
    @ApiModelProperty("预算科目编号")
    @SaturnColumn(description = "预算科目编号")
    private String budgetSubjectsCode;

    @ApiModelProperty("预算科目名称")
    @SaturnColumn(description = "预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("预算科目类型(数据字典)")
    @SaturnColumn(description = "预算科目类型")
    private String subjectsTypeCode;

    @ApiModelProperty("预算科目类型名称")
    @SaturnColumn(description = "预算科目类型")
    private String subjectsTypeName;

    @ApiModelProperty("预算科目分组(数据字典)")
    @SaturnColumn(description = "预算科目分组")
    private String subjectsGroupCode;

    @ApiModelProperty("预算科目分组名称")
    @SaturnColumn(description = "预算科目分组")
    private String subjectsGroupName;

    @ApiModelProperty("是否滚动(数据字典)")
    @SaturnColumn(description = "是否滚动")
    private String isRoll;

    @ApiModelProperty("是否滚动名称")
    @SaturnColumn(description = "是否滚动")
    private String isRollName;

    @ApiModelProperty("控制类型(数据字典)")
    @SaturnColumn(description = "控制类型")
    private String controlType;

    @ApiModelProperty("控制类型名称")
    @SaturnColumn(description = "控制类型")
    private String controlTypeName;

    @ApiModelProperty("数量")
    @SaturnColumn(description = "数量")
    private Integer num;


}