package com.biz.crm.nebular.dms.feepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:费用池条目对应的产品(限制范围)
 * @Author: zhangyuzhu
 * @Date: 2020/9/16 17:35
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "费用池条目对应的产品(限制范围)的vo")
@SaturnEntity(name = "FeePoolDetailGoodsVo", description = "费用池条目对应的产品(限制范围)")
@SaturnDomain(value = "feepooldetailgoods")
public class FeePoolDetailGoodsVo extends CrmExtVo {

    @ApiModelProperty(value = "费用池条目编码")
    @SaturnColumn(description = "费用池条目编码")
    private String feePoolDetailCode;

    @ApiModelProperty(value = "商品编码")
    @SaturnColumn(description = "商品编码")
    private String goodsCode;

    @ApiModelProperty(value = "商品名称")
    @SaturnColumn(description = "商品名称")
    private String goodsName;

}
