package com.biz.crm.nebular.dms.promotion;


import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtEditVo;
import com.biz.crm.util.CommonConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销政策编辑页面编辑请求体VO")
@SaturnEntity(name = "PromotionPolicyEditReqVo", description = "促销政策编辑页面编辑请求体VO")
public class PromotionPolicyEditReqVo extends CrmExtEditVo implements Serializable {
    /**
     * 促销编 码
     */
    @ApiModelProperty(value = "促销编码")
    @SaturnColumn(description = "促销编码")
    private String promotionPolicyCode;

    /**
     * 促销名称
     */
    @ApiModelProperty(value = "促销名称")
    @SaturnColumn(description = "促销名称")
    private String promotionPolicyName;

    /**
     * 促销政策模板模板id
     */
    @ApiModelProperty(value = "促销政策模板模板id")
    @SaturnColumn(description = "促销政策模板模板id")
    private String templateId;

    /**
     * 促销政策模板模板code
     */
    @ApiModelProperty(value = "促销政策模板模板编码")
    @SaturnColumn(description = "促销政策模板模板编码")
    private String templateCode;

    /**
     * 促销政策模板模板name
     */
    @ApiModelProperty(value = "促销政策模板模板名称")
    @SaturnColumn(description = "促销政策模板模板名称")
    private String templateName;
    /**
     * 有效期开始
     */
    @ApiModelProperty(value = "有效期开始-时间")
    @SaturnColumn(description = "有效期开始-时间")
    private String beginTime;
    /**
     * 有效期结束
     */
    @ApiModelProperty(value = "有效期结束-时间")
    @SaturnColumn(description = "有效期结束-时间")
    private String endTime;

    /**
     * 政策叠加
     */
    @ApiModelProperty(value = "政策叠加 字典：yesOrNo")
    @SaturnColumn(description = "政策叠加")
    private String multipleable;

    @ApiModelProperty(value = "政策叠加字典翻译 字典：yesOrNo")
    @SaturnColumn(description = "政策叠加字典翻译")
    @CrmDict(typeCode = "yesOrNo",dictCodeField = "multipleable")
    private String multipleableName;

    /**
     * 首单享受
     */
    @ApiModelProperty(value = "首单享受 字典：yesOrNo")
    @SaturnColumn(description = "首单享受")
    private String firstOrder;

    @ApiModelProperty(value = "首单享受字典翻译 字典：yesOrNo")
    @SaturnColumn(description = "首单享受字典翻译")
    @CrmDict(typeCode = "yesOrNo",dictCodeField = "firstOrder")
    private String firstOrderName;

    /**
     * 促销描述
     */
    @ApiModelProperty(value = "促销描述")
    @SaturnColumn(description = "促销描述")
    private String description;

    /**
     * 商品组合起订量
     */
    @ApiModelProperty(value = "商品组合起订量")
    @SaturnColumn(description = "商品组合起订量")
    private String productsOrderQty;

    /**
     * 组合起订量类型 字典：products_order_qty_type
     */
    @ApiModelProperty(value = "组合起订量类型 字典：products_order_qty_type")
    @SaturnColumn(description = "组合起订量类型 字典：products_order_qty_type")
    private String productsOrderQtyType;

    @ApiModelProperty(value = "组合起订量类型字典翻译")
    @SaturnColumn(description = "组合起订量类型字典翻译")
    @CrmDict(typeCode = "products_order_qty_type",dictCodeField = "productsOrderQtyType")
    private String productsOrderQtyTypeName;

    /**
     * 促销商品
     */
    @ApiModelProperty(value = "促销商品")
    @SaturnColumn(description = "促销商品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private PromotionPolicyProduct promotionPolicyProduct;

    @JsonIgnore
    @SaturnColumn(description = "促销商品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyProductEditVo> allProducts;
    public List<PromotionPolicyProductEditVo> takeAllProducts(){
        if(null == allProducts){
            allProducts = Lists.newArrayList();
            if(null == promotionPolicyProduct){
                return allProducts;
            }
            if(null != promotionPolicyProduct.getProductsCurrentY()){
                List<PromotionPolicyProductEditVo> products = promotionPolicyProduct.getProductsCurrentY();
                products.forEach(v -> {
                    v.setCurrentProduct(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
                });
                allProducts.addAll(products);
            }
            if(null != promotionPolicyProduct.getProductsCurrentN()){
                List<PromotionPolicyProductEditVo> products = promotionPolicyProduct.getProductsCurrentN();
                products.forEach(v -> {
                    v.setCurrentProduct(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
                });
                allProducts.addAll(products);
            }
        }
        return allProducts;
    }


    /**
     * 促销规则
     */
    @ApiModelProperty(value = "促销规则")
    @SaturnColumn(description = "促销规则")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private PromotionPolicyRule promotionPolicyRule;
    @JsonIgnore
    @SaturnColumn(description = "促销商品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyRuleEditVo> allRules;
    public List<PromotionPolicyRuleEditVo> takeAllRules(){
        if(null == allRules){
            allRules = Lists.newArrayList();
            if(null == promotionPolicyRule){
                return allRules;
            }
            if(null != promotionPolicyRule.getRulesAsCalculate()){
                allRules.addAll(promotionPolicyRule.getRulesAsCalculate());
            }
            if(null != promotionPolicyRule.getRulesAsCondition()){
                allRules.addAll(promotionPolicyRule.getRulesAsCondition());
            }
            if(null != promotionPolicyRule.getRulesAsLimited()){
                allRules.addAll(promotionPolicyRule.getRulesAsLimited());
            }
        }
        return allRules;
    }
    /**
     * 促销范围
     */
    @ApiModelProperty(value = "促销范围")
    @SaturnColumn(description = "促销范围")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private PromotionPolicyScope promotionPolicyScope;
    @JsonIgnore
    @SaturnColumn(description = "促销商品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyScopeEditVo> allScopes;

    public List<PromotionPolicyScopeEditVo> takeAllScopes(){
        if(null == allScopes){
            allScopes = Lists.newArrayList();
            if(null == promotionPolicyScope){
                return allScopes;
            }
            this.doCollectScopeToAll(promotionPolicyScope.getScopesAsChannel()
                    , CommonConstant.DMS.PromotionPolicyScopeType.CHANNEL);
            this.doCollectScopeToAll(promotionPolicyScope.getScopesAsCust()
                    , CommonConstant.DMS.PromotionPolicyScopeType.CUST);
            this.doCollectScopeToAll(promotionPolicyScope.getScopesAsOrg()
                    , CommonConstant.DMS.PromotionPolicyScopeType.ORG);
        }
        return allScopes;
    }
    /**
     * 收集促销范围到 allScopes内
     *  @author: luoqi
     *  @Date: 2020-10-20 11:31
     *  @version: V1.0
     *  @Description:
     */
    private void doCollectScopeToAll(PromotionPolicyScopeGroup scopeGroup, CommonConstant.DictItem dictItem){
        if(null == scopeGroup){
            return;
        }
        if(null != scopeGroup.getContainN()){
            List<PromotionPolicyScopeEditVo> scopeEditVos = scopeGroup.getContainN();
            scopeEditVos.forEach(v -> {
                v.setContainable(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
                v.setScopeType(dictItem.getItemCode());
            });
            allScopes.addAll(scopeEditVos);
        }
        if(null != scopeGroup.getContainY()){
            List<PromotionPolicyScopeEditVo> scopeEditVos = scopeGroup.getContainY();
            scopeEditVos.forEach(v -> {
                v.setContainable(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
                v.setScopeType(dictItem.getItemCode());
            });
            allScopes.addAll(scopeGroup.getContainY());
        }
    }

}
