package com.biz.crm.nebular.dms.promotion;


import com.biz.crm.nebular.mdm.CrmExtEditVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 促销政策详细信息VO
 *  @author: luoqi
 *  @Date: 2020-10-21 11:08
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销政策详细信息VO")
public class PromotionPolicyInfoVo extends CrmExtEditVo implements Serializable {
    /**
     * 促销编码
     */
    @ApiModelProperty(value = "促销编码")
    private String promotionPolicyCode;

    /**
     * 促销名称
     */
    @ApiModelProperty(value = "促销名称")
    private String promotionPolicyName;

    /**
     * 促销政策模板模板id
     */
    @ApiModelProperty(value = "促销政策模板模板id")
    private String templateId;

    /**
     * 促销政策模板模板code
     */
    @ApiModelProperty(value = "促销政策模板模板code")
    private String templateCode;

    /**
     * 促销政策模板模板name
     */
    @ApiModelProperty(value = "促销政策模板模板name")
    private String templateName;

    /**
     * 有效期开始
     */
    @ApiModelProperty(value = "有效期开始-时间")
    private String beginTime;

    /**
     * 有效期结束
     */
    @ApiModelProperty(value = "有效期结束-时间")
    private String endTime;


    /**
     * 政策叠加
     */
    @ApiModelProperty(value = "政策叠加")
    private String multipleable;

    /**
     * 首单享受
     */
    @ApiModelProperty(value = "首单享受")
    private String firstOrder;

    /**
     * 促销描述
     */
    @ApiModelProperty(value = "促销描述")
    private String description;

    /**
     * 商品组合起订量
     */
    @ApiModelProperty(value = "商品组合起订量")
    private String productsOrderQty;

    /**
     * 组合起订量类型
     */
    @ApiModelProperty(value = "组合起订量类型")
    private String productsOrderQtyType;
}
