package com.biz.crm.nebular.mdm.button;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 按钮表请求vo
 *
 * @author zxw
 * @date 2020-11-18 11:33:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmButtonReqVo", description = "按钮")
public class MdmButtonReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("菜单编码集合")
    private List<String> functionCodeList;

    @ApiModelProperty("菜单编码")
    private String functionCode;

    @ApiModelProperty("按钮编码")
    private String buttonCode;

    @ApiModelProperty("按扭名称")
    private String buttonName;

    @ApiModelProperty("图标")
    private String buttonIcon;

    @ApiModelProperty("是否选中:1是0否")
    private String select;

    @ApiModelProperty("按钮类型:0表头按钮，1行按钮")
    private String buttonType;

    @ApiModelProperty("按钮操作类型")
    private String buttonOperationType;

    @ApiModelProperty("url")
    private String apiUrl;

    @ApiModelProperty("询问语")
    private String ask;

    @ApiModelProperty("按钮排序")
    private Integer buttonOrder;

    @ApiModelProperty("功能编码")
    private String doCode;

    @ApiModelProperty("显示模式：true显示，false隐藏")
    private Boolean visible;

    @ApiModelProperty("功能地址")
    private String queryUrl;

}