package com.biz.crm.nebular.mdm.coderule.resp;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 编码规则返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-05 10:47:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "编码规则")
@SaturnEntity(name = "MdmCodeRuleRespVo", description = "编码规则")
public class MdmCodeRuleRespVo extends UuidVo {

    @ApiModelProperty("业务key")
    @SaturnColumn(description = "业务key")
    private String ruleCode;

    @ApiModelProperty("前缀")
    @SaturnColumn(description = "前缀")
    private String prefix;

    @ApiModelProperty("时间戳格式")
    @SaturnColumn(description = "时间戳格式")
    private String dateFormat;

    @ApiModelProperty("编码总长度")
    @SaturnColumn(description = "编码总长度")
    private Integer codeLength;

    @ApiModelProperty("规则描述")
    @SaturnColumn(description = "规则描述")
    private String ruleDescription;

    @ApiModelProperty("起始值")
    @SaturnColumn(description = "起始值")
    private Integer initialValue;

    @ApiModelProperty("当前值")
    @SaturnColumn(description = "当前值")
    private Integer currentValue;

    @ApiModelProperty("生成时间")
    @SaturnColumn(description = "生成时间")
    private String generateDate;

    @ApiModelProperty("创建日期")
    @SaturnColumn(description = "创建日期")
    private String createDate;

    @ApiModelProperty("创建时间")
    @SaturnColumn(description = "创建时间")
    private String createDateSecond;

    @ApiModelProperty("创建人姓名")
    @SaturnColumn(description = "创建人姓名")
    private String createName;

    @ApiModelProperty("更新日期")
    @SaturnColumn(description = "更新日期")
    private String updateDate;

    @ApiModelProperty("更新时间")
    @SaturnColumn(description = "更新时间")
    private String updateDateSecond;

    @ApiModelProperty("更新人姓名")
    @SaturnColumn(description = "更新人姓名")
    private String updateName;

}