package com.biz.crm.nebular.mdm.customermaterial.resp;

import com.biz.crm.common.ParamCheck;
import com.biz.crm.nebular.mdm.enums.ParamCheckTypeEnum;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

import java.io.Serializable;

/**
 * @author liaohua
 * @date 2020/9/22 2:00 下午
 */
@NebulaExcelImport(startRow = 1)
public class MdmCustomerMaterialImportExcelVo implements Serializable {

  /**
   * 客户组织编码
   */
  @NebulaExcelColumn(order = 0, title = "客户组织编码")
  @ParamCheck(isNotNull = true, msg = "客户组织编码不能为空")
  private String customerOrgCode;

  /**
   * 条形码
   */
  @NebulaExcelColumn(order = 1, title = "条形码")
  @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "条形码不能为空", length = 128)
  private String barCode;

  /**
   * 物料编码
   */
  @NebulaExcelColumn(order = 2, title = "物料编码")
  @ParamCheck(isNotNull = true, msg = "物料编码不能为空")
  private String materialCode;

  public String getCustomerOrgCode() {
    return customerOrgCode;
  }

  public void setCustomerOrgCode(String customerOrgCode) {
    this.customerOrgCode = customerOrgCode;
  }

  public String getBarCode() {
    return barCode;
  }

  public void setBarCode(String barCode) {
    this.barCode = barCode;
  }

  public String getMaterialCode() {
    return materialCode;
  }

  public void setMaterialCode(String materialCode) {
    this.materialCode = materialCode;
  }

  @Override
  public String toString() {
    return "MdmCustomerMaterialImportExcelVo{" +
        "customerOrgCode='" + customerOrgCode + '\'' +
        ", barCode='" + barCode + '\'' +
        ", materialCode='" + materialCode + '\'' +
        '}';
  }
}
