package com.biz.crm.nebular.mdm.function;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 菜单表请求vo
 *
 * @author zxw
 * @date 2020-11-18 10:26:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmFunctionReqVo", description = "菜单表")
public class MdmFunctionReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("菜单编码")
    private String functionCode;

    @ApiModelProperty("菜单编码集合")
    private List<String> functionCodeList;

    @ApiModelProperty("菜单名称")
    private String functionName;

    @ApiModelProperty("菜单排序")
    private String functionOrder;

    @ApiModelProperty("菜单地址")
    private String functionUrl;

    @ApiModelProperty("上级菜单编码")
    private String parentCode;

    @ApiModelProperty("图标")
    private String functionIcon;

    @ApiModelProperty("所属模块，1：mdm，2：dms，3：tpm，4：sfa")
    private String functionModule;

    @ApiModelProperty("菜单类型：0：系统菜单，1：dms商城，2：dms小程序，3:sfa小程序，4：sfaapp")
    private String functionConfig;

    private String functionLevel;

    @ApiModelProperty("角色编码")
    private String roleCode;

    @ApiModelProperty("是否允许页面配置 Y：是 N ：否 ")
    private String pageConfig;

}