package com.biz.crm.nebular.mdm.icon;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-12-05 11:10:24
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "图标返回")
@SaturnEntity(name = "MdmIconRespVo", description = "图标返回")
public class MdmIconRespVo extends CrmExtTenVo {

    @ApiModelProperty("图标编码")
    @SaturnColumn(description = "图标编码")
    private String iconCode;

    @ApiModelProperty("图标名称")
    @SaturnColumn(description = "图标名称")
    private String iconName;

    @ApiModelProperty("图标类型")
    @SaturnColumn(description = "图标类型")
    private String iconType;

    @ApiModelProperty("图标类型名称")
    @SaturnColumn(description = "图标类型名称")
    @CrmDict(typeCode = DictConstant.ICON_TYPE,dictCodeField = "iconType")
    private String iconTypeName;

    @ApiModelProperty("图标后缀")
    @SaturnColumn(description = "图标后缀")
    private String iconSuffix;

    @ApiModelProperty("图标样式")
    @SaturnColumn(description = "图标样式")
    private String iconStyle;

    @ApiModelProperty("图标效果")
    @SaturnColumn(description = "图标效果")
    private String iconEffect;

}