package com.biz.crm.nebular.mdm.priceconditiontype.req;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 条件字段类型主表 请求vo
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPriceConditionTypeReqVo", description = "条件字段类型主表 ")
public class MdmPriceConditionTypeReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("条件字段类型编码")
    private String conditionTypeCode;

    @ApiModelProperty("条件字段类型描述")
    private String conditionTypeDesc;

    @ApiModelProperty("抬头/行项目（数据字典condition_type_type）")
    private String conditionTypeType;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    @SaturnColumn(description = "条件类型分类关联集合")
    private List<MdmPriceConditionTypeRelGroupReqVo> conditionTypeRelGroupReqVoList;

}