package com.biz.crm.nebular.mdm.priceconditiontype.resp;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.priceconditiongroup.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 条件字段类型和条件字段分类的关系表 返回vo
 *
 * @author huanglong
 * @date 2020-10-20 10:57:01
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "条件字段类型和条件字段分类的关系表 ")
@SaturnEntity(name = "MdmPriceConditionTypeRelGroupRespVo", description = "条件字段类型和条件字段分类的关系表 ")
public class MdmPriceConditionTypeRelGroupRespVo extends CrmBaseVo {
    @ApiModelProperty("条件字段类型编码")
    @SaturnColumn(description = "条件字段类型编码")
    private String conditionTypeCode;

    @ApiModelProperty("条件字段分类编码")
    @SaturnColumn(description = "条件字段分类编码")
    private String conditionGroupCode;

    @ApiModelProperty("条件字段分类名称")
    @SaturnColumn(description = "条件字段分类名称")
    private String conditionGroupName;

    @ApiModelProperty("排序")
    @SaturnColumn(description = "排序")
    private Integer sortNum;

    @ApiModelProperty("计数在关联表中同ConditionGroup的记录条数，后端功能需要")
    @SaturnColumn(description = "计数在关联表中同ConditionGroup的记录条数，后端功能需要")
    private Integer countConditionGroupRecords;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    @SaturnColumn(description = "条件分类的关联条件字段集合")
    private List<MdmPriceConditionGroupRelFieldRespVo> mdmPriceConditionGroupRelFieldRespVos;
}