package com.biz.crm.nebular.mdm.product.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 商品主表返回vo
 *
 * @author huang.long
 * @date 2020-08-28 16:07:20
 */
@Data
@ApiModel(value = "商品信息返回VO")
@CrmColumnResolve
@SaturnDomain(value = "mdmproductrespvo")
@SaturnEntity(name = "MdmProductRespVo", description = "商品管理")
public class MdmProductRespVo extends CrmExtVo {
    @ApiModelProperty("商品编码")
    @SaturnColumn(description = "商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    @SaturnColumn(description = "商品名称")
    private String productName;

    @ApiModelProperty("产品层级编码")
    @SaturnColumn(description = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级")
    @SaturnColumn(description = "产品层级")
    private String productLevelName;

    @ApiModelProperty("商品类型(数据字典)")
    @SaturnColumn(description = "商品类型")
    private String productType;

    @ApiModelProperty("商品类型")
    @SaturnColumn(description = "商品类型")
    @CrmDict( typeCode = "product_type", dictCodeField = "productType")
    private String productTypeName;

    @ApiModelProperty("销售单位(字典编码)")
    @SaturnColumn(description = "销售单位(字典编码)")
    private String saleUnit;

    @ApiModelProperty("销售单位")
    @SaturnColumn(description = "销售单位")
    @CrmDict( typeCode = "product_sale_unit", dictCodeField = "saleUnit")
    private String saleUnitName;

    @ApiModelProperty("规格")
    @SaturnColumn(description = "规格")
    private String spec;

    @ApiModelProperty("基本单位(字典编码)")
    @SaturnColumn(description = "基本单位(字典编码)")
    private String baseUnit;

    @ApiModelProperty("基本单位")
    @SaturnColumn(description = "基本单位")
    @CrmDict( typeCode = "product_base_unit", dictCodeField = "baseUnit")
    private String baseUnitName;

    @ApiModelProperty("开始日期")
    @SaturnColumn(description = "开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    @SaturnColumn(description = "开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    @SaturnColumn(description = "结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    @SaturnColumn(description = "结束时间")
    private String endDateSecond;

    @ApiModelProperty("上下架状态(数据字典)")
    @SaturnColumn(description = "上下架状态(字典编码)")
    private String isShelf;

    @ApiModelProperty("上下架状态")
    @SaturnColumn(description = "上下架状态")
    @CrmDict( typeCode = "is_shelf", dictCodeField = "isShelf")
    private String isShelfName;

    @ApiModelProperty("条形码")
    @SaturnColumn(description = "条形码")
    private String barCode;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "物料信息")
    private List<MdmProductMaterialRespVo> materialList;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "图片信息")
    private List<MdmProductMediaRespVo> pictureList;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "视频信息")
    private List<MdmProductMediaRespVo> videoList;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    @SaturnColumn(description = "富文本信息")
    private MdmProductIntroductionRespVo introductionVo;

}