package com.biz.crm.nebular.sfa.visitstep.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 拜访步骤(竞品采集);请求vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitStepColletReqVo", description = "拜访步骤(竞品采集);")
public class SfaVisitStepColletReqVo extends CrmExtVo {
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("拜访编码")
    private String visitId;

    @ApiModelProperty("网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    private String clientType;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("竞品商品清单")
    private List<SfaVisitStepColletItemReqVo> sfaVisitStepColletItemReqVos;

    @ApiModelProperty("竞品图片列表")
    private List<SfaVisitPictureReqVo> sfaVisitPictureReqVos;


}