package com.biz.crm.nebular.sfa.worksign.req;

import com.alibaba.fastjson.JSON;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * 考勤管理-各种申请-日期明细 请求vo
 *
 * @author ren.gang
 * @date 2020-11-20 15:00:38
 */
@Data
@ApiModel(value = "SfaApplyTimeInfoReqVo", description = "考勤管理-日期明细（申请）Vo ")
public class SfaApplyTimeInfoReqVo {

    @ApiModelProperty("日期")
    private String timeStr;

    @ApiModelProperty("日期类型(1全天，2上午，3下午)")
    private String timeType;

    /**
     * 获取本对象列表中指定日期数据的 日期类型
     * @param json
     * @param date
     * @return
     */
    public static String getTypeByDate(String json, String date) {
        if(StringUtils.isEmpty(json)) {
            return null;
        }
        for(SfaApplyTimeInfoReqVo info: JSON.parseArray(json, SfaApplyTimeInfoReqVo.class)) {
            if(info.getTimeStr().equals(date)) {
                return info.getTimeType();
            }
        }
        return null;
    }

}