package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 考勤打卡记录表 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "考勤打卡记录表 ")
@SaturnEntity(name = "SfaWorkSignRecordRespVo", description = "考勤打卡记录表 ")
public class SfaWorkSignRecordRespVo extends CrmExtTenVo {
    @ApiModelProperty("考勤规则明细表id 考勤规则明细表id")
    @SaturnColumn(description = "考勤规则明细表id 考勤规则明细表id")
    private String wsRuleInfoId;

    @ApiModelProperty("打卡类型 CLOCK_IN : 上班签到; CLOCK_OUT : 下班签退;")
    @SaturnColumn(description = "打卡类型 打卡类型（1:上班签到;2:下班签退）")
    private String workSignType;

    @ApiModelProperty("打卡类型描述 打卡类型描述")
    @SaturnColumn(description = "打卡类型描述 打卡类型描述")
    private String workSignDesc;

    @ApiModelProperty("考勤时间 考勤时间(HH:mm:ss)")
    @SaturnColumn(description = "考勤时间 考勤时间(HH:mm:ss)")
    private String workSignTime;
    @ApiModelProperty("考勤日期")
    @SaturnColumn(description = "考勤日期")
    private String ruleDate;
    @ApiModelProperty("考勤地点 考勤地点")
    @SaturnColumn(description = "考勤地点 考勤地点")
    private String workSignPlace;

    @ApiModelProperty("打卡经度 打卡经度")
    @SaturnColumn(description = "打卡经度 打卡经度")
    private String lngIn;

    @ApiModelProperty("打卡纬度 打卡纬度")
    @SaturnColumn(description = "打卡纬度 打卡纬度")
    private String latIn;

    @ApiModelProperty("考勤状态 NONE:未打卡;OK:正常;BE_LATE:迟到;LEAVE_EARLY:早退;")
    @SaturnColumn(description = "考勤状态 NONE:未打卡;OK:正常;BE_LATE:迟到;LEAVE_EARLY:早退;")
    private String workSignStatus;

    @ApiModelProperty("考勤地点状态 OK : 正常; EX : 异常;")
    @SaturnColumn(description = "考勤地点状态 OK : 正常; EX : 异常;")
    private String wsPlaceStatus;

    @ApiModelProperty("打卡人员id 打卡人员id")
    @SaturnColumn(description = "打卡人员id 打卡人员id")
    private String wsUserId;

    @ApiModelProperty("打卡人员账号 打卡人员账号")
    @SaturnColumn(description = "打卡人员账号 打卡人员账号")
    private String wsUserName;

    @ApiModelProperty("打卡人员名称 打卡人员名称")
    @SaturnColumn(description = "打卡人员名称 打卡人员名称")
    private String wsRealName;

    @ApiModelProperty("打卡职位id 打卡职位id")
    @SaturnColumn(description = "打卡职位id 打卡职位id")
    private String wsPosId;

    @ApiModelProperty("打卡职位编码 打卡职位编码")
    @SaturnColumn(description = "打卡职位编码 打卡职位编码")
    private String wsPosCode;

    @ApiModelProperty("打卡职位名称 打卡职位名称")
    @SaturnColumn(description = "打卡职位名称 打卡职位名称")
    private String wsPosName;

    @ApiModelProperty("打卡组织id 打卡组织id")
    @SaturnColumn(description = "打卡组织id 打卡组织id")
    private String wsOrgId;

    @ApiModelProperty("打卡组织编码 打卡组织编码")
    @SaturnColumn(description = "打卡组织编码 打卡组织编码")
    private String wsOrgCode;

    @ApiModelProperty("打卡组织名称 打卡组织名称")
    @SaturnColumn(description = "打卡组织名称 打卡组织名称")
    private String wsOrgName;
    /**
     * 上级组织编码 组织编码
     */
    @SaturnColumn(description = "上级组织编码")
    private String wsParentOrgCode;

    /**
     * 上级组织名称 组织名称
     */
    @SaturnColumn(description = "上级组织名称")
    private String wsParentOrgName;
    /**
     * 上班打卡开始时间 上班打卡开始时间(HH:mm:ss)
     */
    @ApiModelProperty("上班打卡开始时间")
    @SaturnColumn(description = "上班打卡开始时间")
    private String gotoStartTime;

    @ApiModelProperty("上班打卡时间")
    @SaturnColumn(description = "上班打卡时间")
    private String gotoTime;
    /**
     * 上班打卡结束时间 上班打卡结束时间(HH:mm:ss)
     */
    @ApiModelProperty("上班打卡结束时间")
    @SaturnColumn(description = "上班打卡结束时间")
    private String gotoEndTime;


    @ApiModelProperty("下班打卡时间")
    @SaturnColumn(description = "下班打卡时间")
    private String gooffTime;
    /**
     * 下班打卡开始时间 下班打卡开始时间(HH:mm:ss)
     */
    @ApiModelProperty("下班打卡开始时间")
    @SaturnColumn(description = "下班打卡开始时间")
    private String gooffStartTime;

    /**
     * 下班打卡结束时间 下班打卡结束时间(HH:mm:ss)
     */
    @ApiModelProperty("下班打卡结束时间")
    @SaturnColumn(description = "下班打卡结束时间")
    private String gooffEndTime;


    @ApiModelProperty("考勤照片 考勤照片")
    @SaturnColumn(description = "考勤照片")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSignPictureRespVo> sfaWorkSignPictureRespVos;

}