package com.biz.crm.nebular.tpm.account.req;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 费用上账发票关联表;请求vo
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAccountInvoiceReqVo", description = "费用上账发票关联表;")
public class TpmAccountInvoiceReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("分组id(标识同一次提交的数据)")
    private String groupId;

    @ApiModelProperty("上账编码")
    private List<String> accountCodes;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("发票编码")
    private String invoiceCode;

    @ApiModelProperty("申请科目编码")
    private String applyBudgetSubjectsCode;

    @ApiModelProperty("申请科目名称")
    private String applyBudgetSubjectsName;

    @ApiModelProperty("上账科目编码")
    private String accountBudgetSubjectsCode;

    @ApiModelProperty("上账科目名称")
    private String accountBudgetSubjectsName;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税金")
    private String taxAmount;

    @ApiModelProperty("发票金额(不含税)")
    private BigDecimal invoiceAmount;

    @ApiModelProperty("进项税转出金额")
    private BigDecimal taxOutAmount;

    @ApiModelProperty("ERP成本中心(文本框输入)")
    private String costCenter;

    @ApiModelProperty("活动细类编码集合")
    private List<String> fineCodeList;

}