package com.biz.crm.nebular.tpm.act.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动预算信息表;返回vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动预算信息表;")
@CrmColumnResolve
@SaturnEntity(name = "TpmActBudgetRespVo", description = "活动预算信息表;")
public class TpmActBudgetRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("费用预算编码")
    @SaturnColumn(description = "费用预算编码")
    private String feeBudgetCode;

    @ApiModelProperty("费用预算控制维度id")
    @SaturnColumn(description = "费用预算控制维度id")
    private String controlId;

    @ApiModelProperty("费用预算类型(字典)")
    @SaturnColumn(description = "费用预算类型(字典)")
    private String feeBudgetType;

    @ApiModelProperty("组织类型")
    @SaturnColumn(description = "组织类型")
    private String orgType;

    @ApiModelProperty("预算扣减顺序")
    @SaturnColumn(description = "预算扣减顺序")
    private Integer reduceOrder;

    @ApiModelProperty("预算扣减比例")
    @SaturnColumn(description = "预算扣减比例")
    private BigDecimal reduceRatio;

}