package com.biz.crm.nebular.tpm.audit.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 核销申请资料表 返回vo
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "核销申请资料表 ")
@CrmColumnResolve
@SaturnEntity(name = "TpmAuditFileRespVo", description = "核销申请资料表 ")
public class TpmAuditFileRespVo extends CrmExtVo {
    @ApiModelProperty("核销申请编码")
    @SaturnColumn(description = "核销申请编码")
    private String auditCode;

    @ApiModelProperty("核销申请明细编码")
    @SaturnColumn(description = "核销申请明细编码")
    private String auditDetailCode;

    @ApiModelProperty("核销申请资料类型(1,核销资料,2,活动取证资料,3,审批资料)")
    @SaturnColumn(description = "核销申请资料类型(1,核销资料,2,活动取证资料,3,审批资料)")
    private Integer auditFileType;

    @ApiModelProperty("活动细类编码")
    @SaturnColumn(description = "活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    @SaturnColumn(description = "活动细类名称")
    private String fineName;

    @ApiModelProperty("要求核销资料名称(多个名字)")
    @SaturnColumn(description = "要求核销资料名称(多个名字)")
    private String auditRequireNames;

    @ApiModelProperty("描述")
    @SaturnColumn(description = "描述")
    private String fileDesc;

    @ApiModelProperty("示例文件集合")
    @SaturnColumn(description = "示例文件集合")
    private String exampleFiles;

    @ApiModelProperty("文件地址")
    @SaturnColumn(description = "文件地址")
    private String addressUrl;

    @ApiModelProperty("对象名称")
    @SaturnColumn(description = "对象名称")
    private String objectName;

}