package com.biz.crm.nebular.tpm.costtypecategories.resp;

import com.biz.crm.common.DictItemVo;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.List;

/**
 * 活动大类 返回vo
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动大类 ")
@CrmColumnResolve
@SaturnEntity(name = "TpmCostTypeCategoriesRespVo", description = "活动大类 ")
public class TpmCostTypeCategoriesRespVo extends CrmExtVo {
    @ApiModelProperty("活动大类编码")
    @SaturnColumn(description = "活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动大类名称")
    @SaturnColumn(description = "活动大类名称")
    private String categoriesName;

    @ApiModelProperty("财务费用归类(字典)")
    @SaturnColumn(description = "财务费用归类")
    private String financialFeeType;

    @ApiModelProperty("财务费用归类(名称)")
    @SaturnColumn(description = "财务费用归类")
    private String financialFeeTypeName;

    @ApiModelProperty("业务费用归类(字典)")
    @SaturnColumn(description = "业务费用归类")
    private String businessFeeType;

    @ApiModelProperty("业务费用归类(名称)")
    @SaturnColumn(description = "业务费用归类")
    private String businessFeeTypeName;

    @ApiModelProperty("关联预算科目(科目编码)")
    @SaturnColumn(description = "关联预算科目(科目编码)")
    private String budgetSubjectsCode;

    @ApiModelProperty("关联预算科目(科目名称)")
    @SaturnColumn(description = "预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("适用活动类型(字典)")
    @SaturnColumn(description = "适用活动类型")
    private String activityCategoriesType;

    @ApiModelProperty("适用活动类型集合")
    @SaturnColumn(description = "适用活动类型集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<DictItemVo> activityCategoriesTypes;

    @ApiModelProperty("适用活动类型名称")
    @SaturnColumn(description = "适用活动类型")
    private String activityCategoriesTypeName;

    @ApiModelProperty("活动申请表单编码(配置好的表单编码)")
    @SaturnColumn(description = "项目活动申请表单编码(配置好的表单编码)")
    private String formCode;

    @ApiModelProperty("活动申请表单名称(配置好的表单名称)")
    @SaturnColumn(description = "项目活动申请表单名称(配置好的表单名称)")
    private String formName;

    @ApiModelProperty("范围信息(组织包含)")
    @SaturnColumn(description = "范围信息(组织包含")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmCostTypeCategoriesRangeRespVo> containOrgRangeVos;

    @ApiModelProperty("范围信息(组织非包含)")
    @SaturnColumn(description = "范围信息(组织非包含)")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmCostTypeCategoriesRangeRespVo> nonContainOrgRangeVos;

    @ApiModelProperty("范围信息(组织类型包含)")
    @SaturnColumn(description = "范围信息(组织类型包含)")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmCostTypeCategoriesRangeRespVo> containOrgTypeRangeVos;

    @ApiModelProperty("范围信息(组织类型非包含)")
    @SaturnColumn(description = "范围信息(组织类型非包含)")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmCostTypeCategoriesRangeRespVo> nonContainOrgTypeRangeVos;

    @ApiModelProperty("关联活动细类")
    @SaturnColumn(description = "关联活动细类")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmCostTypeCategoriesFineRespVo> fineVos;


}