package com.biz.crm.nebular.tpm.costtypefine.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmActCollectFieldFineRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 活动细类 请求vo
 *
 * @author huanglong
 * @date 2020-09-14 11:01:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmCostTypeFineReqVo", description = "活动细类 ")
public class TpmCostTypeFineReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类编码集合")
    private List<String> fineCodeList;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("ERP会计科目编码")
    private String financeSubjectsErpCode;

    @ApiModelProperty("ERP会计科目名称")
    private String financeSubjectsErpName;

    @ApiModelProperty("活动发布需求(字典)")
    private String activityReleaseNeed;

    @ApiModelProperty("活动方式(字典)")
    private String activityType;

    @ApiModelProperty("费用是否分摊到产品(Y/N)")
    private String isShareToProduct;

    @ApiModelProperty("支付方式(集合的json,字典)")
    private String payTypeList;

    @ApiModelProperty("是否核销")
    private String isAudit;

    @ApiModelProperty("是否自动核销")
    private String isAutoAudit;

    @ApiModelProperty("允许多次核销")
    private String isAllowRepeatAudit;

    @ApiModelProperty("超额核销比例")
    private BigDecimal extraAuditRatio;

    @ApiModelProperty("核销有效期(月)")
    private Integer auditValidity;

    @ApiModelProperty("是否推送SFA")
    private String isSendSfa;

    @ApiModelProperty("是否推送AI")
    private String isSendAi;

    @ApiModelProperty("采集要求(集合的json)")
    private String collectRequireList;

    @ApiModelProperty("核销资料要求(集合的json)")
    private String auditRequireList;

    @ApiModelProperty("采集字段集合")
    private List<TpmActCollectFieldFineReqVo> collectFieldList;



}