package com.biz.crm.nebular.tpm.feebudget.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Collection;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 费用预算管控维度表 请求vo
 *
 * @author huanglong
 * @date 2020-09-23 18:52:12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmFeeBudgetControlReqVo", description = "费用预算管控维度表 ")
public class TpmFeeBudgetControlReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private Collection<String> ids;

    @ApiModelProperty("费用预算类型(字典)")
    private String feeBudgetType;

    @ApiModelProperty("费用预算编码集合")
    private String feeBudgetCodes;

    @ApiModelProperty("搜索key")
    private String selectKey;

    @ApiModelProperty("预算年份(字典)")
    private String budgetYear;

    @ApiModelProperty("预算季度(字典)")
    private String budgetQuater;

    @ApiModelProperty("预算月份(字典)")
    private String budgetMonth;

    @ApiModelProperty("预算科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("组织类型")
    private String orgType;

    @ApiModelProperty("组织类型名称")
    private String orgTypeName;

    @ApiModelProperty("渠道(字典)")
    private String channel;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("可用余额")
    private BigDecimal canUseAmount;

    @ApiModelProperty("活动类型")
    private String actType;

    @ApiModelProperty("活动开始日期")
    private String actBeginDate;

    @ApiModelProperty("活动结束日期")
    private String actEndDate;

    @ApiModelProperty("搜索key的集合")
    private List<String> selectKeys;


}