package com.biz.crm.nebular.tpm.fiscalyear.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 财年设置 财年设置表返回vo
 *
 * @author huang.long
 * @date 2020-09-08 11:19:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "财年设置")
@CrmColumnResolve
@SaturnEntity(name = "TpmFiscalYearSettingRespVo", description = "财年设置 财年设置表")
public class TpmFiscalYearSettingRespVo extends CrmExtVo {
    @ApiModelProperty("预算年(字典编码)")
    @SaturnColumn(description = "预算财年")
    private String year;

    @ApiModelProperty("预算财年名称")
    @SaturnColumn(description = "预算财年")
    private String yearName;

    @ApiModelProperty("预算季度(字典编码)")
    @SaturnColumn(description = "季度")
    private String quater;

    @ApiModelProperty("季度名称")
    @SaturnColumn(description = "季度")
    private String quaterName;

    @ApiModelProperty("预算月度(字典编码)")
    @SaturnColumn(description = "月度")
    private String month;

    @ApiModelProperty("月度名称")
    @SaturnColumn(description = "月度")
    private String monthName;

    @ApiModelProperty("开始日期")
    @SaturnColumn(description = "开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    @SaturnColumn(description = "开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    @SaturnColumn(description = "结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    @SaturnColumn(description = "结束时间")
    private String endDateSecond;

}