package com.biz.crm.nebular.activiti.act.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author weston
 * @date 2020-12-23
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "TaskCopyReqVO", description = "节点抄送请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class TaskCopyReqVO {

    @ApiModelProperty(value = "节点ID", required = true)
    private String taskId;

    @ApiModelProperty(value = "抄送来源用户", required = true)
    private String fromUserCode;

    @ApiModelProperty(value = "抄送来源用户岗位", required = true)
    private String fromUserPosCode;

    @ApiModelProperty(value = "备注(非必填)")
    private String remark;

    @ApiModelProperty(value = "抄送目标用户", required = true)
    private List<CopyToUserReqVO> users;
}
