package com.biz.crm.nebular.activiti.task.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author weston
 * @date 2020-12-23
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "抄送节点响应vo")
@SaturnEntity(name = "CopyTaskRspVO", description = "抄送节点响应vo")
public class CopyTaskRspVO {
    @ApiModelProperty(value = "抄送节点ID")
    private String id;

    @ApiModelProperty(value = "源节点ID")
    private String taskId;

    @ApiModelProperty(value = "任务节点定义key")
    private String taskDefKey;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "抄送时间")
    private Date createTime;

    @ApiModelProperty(value = "处理时间")
    private Date readTime;

    @ApiModelProperty(value = "流程名称")
    private String processName;

    @ApiModelProperty(value = "表单编号")
    private String formNo;

    @ApiModelProperty(value = "流程标题")
    private String title;

    @ApiModelProperty(value = "流程实例ID")
    private String processInstId;

    @ApiModelProperty(value = "抄送给的用户编码")
    private String userCode;

    @ApiModelProperty(value = "抄送给的用户名称")
    private String userName;

    @ApiModelProperty(value = "抄送给的用户岗位编码")
    private String posCode;

    @ApiModelProperty(value = "抄送给的用户岗位名称")
    private String posName;

    @ApiModelProperty(value = "抄送来源人的用户编码")
    private String fromUser;

    @ApiModelProperty(value = "抄送来源人的用户名称")
    private String fromUserName;

    @ApiModelProperty(value = "抄送来源人的岗位编码")
    private String fromPosCode;

    @ApiModelProperty(value = "抄送来源人的岗位名称")
    private String fromPosName;

    @ApiModelProperty(value = "抄送节点状态(1=未读2=已阅)")
    private Integer status;

    @ApiModelProperty(value = "抄送节点状态描述")
    private String statusDesc;
}

