package com.biz.crm.nebular.dms.feepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Description:费用池明细关联的log
 * @Author: zhangyuzhu
 * @Date: 2020/9/16 17:35
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "费用池明细关联的log的vo")
@SaturnEntity(name = "FeePoolDetailLogVo", description = "费用池明细关联的log")
@SaturnDomain(value = "feepooldetaillog")
public class FeePoolDetailLogVo extends CrmExtVo {

    @ApiModelProperty(value = "费用池编码")
    @SaturnColumn(description = "费用池编码")
    private String feePoolCode;

    @ApiModelProperty(value = "费用池条目编码")
    @SaturnColumn(description = "费用池条目编码")
    private String feePoolDetailCode;

    @ApiModelProperty(value = "来源业务单号")
    @SaturnColumn(description = "来源业务单号")
    private String sourbNo;

    @ApiModelProperty(value = "调整金额")
    @SaturnColumn(description = "调整金额")
    private BigDecimal adjustmentAmount;

    @ApiModelProperty(value = "调整类型")
    @SaturnColumn(description = "调整类型")
    private Integer adjustmentType;


}
