package com.biz.crm.nebular.mdm.availablelistrule;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/24 16:59
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "可够清单规则商品范围信息的vo")
@SaturnEntity(name = "AvailableListRuleGoodsVo", description = "可够清单规则商品范围信息")
public class AvailableListRuleGoodsVo extends CrmExtVo {

    @ApiModelProperty(value = "规则编码")
    @SaturnColumn(description = "规则编码")
    private String ruleCode;

    @ApiModelProperty(value = "商品编码")
    @SaturnColumn(description = "商品编码")
    private String goodsCode;

    @ApiModelProperty(value = "商品名称")
    @SaturnColumn(description = "商品名称")
    private String goodsName;

    @ApiModelProperty(value = "商品规格")
    @SaturnColumn(description = "商品规格")
    private String productSpec;

    @ApiModelProperty(value = "产品层级code")
    @SaturnColumn(description = "产品层级code")
    private String productLevelCode;

    @ApiModelProperty(value = "产品层级名称")
    @SaturnColumn(description = "产品层级名称")
    private String productLevelName;
}
