package com.biz.crm.nebular.mdm.humanarea;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 替换对接职位列表响应
 *
 * @author zxw
 * @date 2020-10-12 15:37
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionSelectPageRespVo", description = "职位选择响应")
@SaturnEntity(name = "MdmPositionSelectPageRespVo", description = "职位选择响应")
public class MdmPositionSelectPageRespVo {

    @ApiModelProperty("用户帐号")
    @SaturnColumn(description = "用户帐号")
    private String userAccount;

    @ApiModelProperty("用户名称")
    @SaturnColumn(description = "用户名称")
    private String userName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String positionName;

    @ApiModelProperty("职位级别编码")
    @SaturnColumn(description = "职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别")
    @SaturnColumn(description = "职位级别")
    private String positionLevelName;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("上级职位名称")
    @SaturnColumn(description = "上级职位名称")
    private String parentName;
}
