package com.biz.crm.nebular.mdm.position.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 职位表返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位详情返回VO")
@CrmColumnResolve
public class MdmPositionDetailRespVo extends CrmTreeTenVo {

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("关联组织编码")
    private String orgCode;

    @ApiModelProperty("上级职位编码")
    private String parentCode;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("是否主职位1是0否")
    private String primaryFlag;

    @ApiModelProperty("职位冗余全部关联角色编码集合，英文逗号间隔")
    private String roleCodeRedundancy;

    @ApiModelProperty("职位冗余全部关联角色名称集合，英文逗号间隔")
    private String roleNameRedundancy;

    @ApiModelProperty("关联用户")
    private MdmUserRespVo user;

    @ApiModelProperty("所属组织")
    private MdmOrgRespVo org;

    @ApiModelProperty("关联角色")
    private List<MdmRoleRespVo> roleList;

    @ApiModelProperty("关联流程角色")
    private List<MdmBpmRoleRespVo> bpmRoleList;

}