package com.biz.crm.nebular.sfa.calculateSalaryDate.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.calculateSalaryDate.resp.SfaCalculateSalaryDateRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 计算薪资年 请求vo
 *
 * @author lf
 * @date 2020-11-25 17:04:34
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaCalculateSalaryDateReqVo", description = "计算薪资年 ")
public class SfaCalculateSalaryDateReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("年份")
    private String year;

    @ApiModelProperty("日期")
    private String date;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("真实姓名")
    private String realName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("开始时间")
    private String startDate;

    @ApiModelProperty("结束时间")
    private String endDate;

    @ApiModelProperty("日期信息")
    private List<SfaCalculateSalaryDateRespVo> dateRespVoList;

}