package com.biz.crm.nebular.sfa.calculateSalaryDate.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 计算薪资日期日志表返回vo
 *
 * @author lf
 * @date 2020-11-25 17:04:34
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "计算薪资日期日志表")
@SaturnEntity(name = "SfaCalculateSalaryDateLogRespVo", description = "计算薪资日期日志表")
public class SfaCalculateSalaryDateLogRespVo extends CrmExtTenVo {
    @ApiModelProperty("年份")
    @SaturnColumn(description = "年份")
    private String year;

    @ApiModelProperty("日期")
    @SaturnColumn(description = "日期")
    private String date;

    @ApiModelProperty("操作类型")
    @SaturnColumn(description = "操作类型")
    private String operationType;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("真实姓名")
    @SaturnColumn(description = "真实姓名")
    private String realName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

}