package com.biz.crm.nebular.sfa.worksignrule.resp;

import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignRuleVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 考勤规则;考勤规则返回vo
 *
 * @author liuhongming
 * @date 2020-09-16 14:50:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "考勤规则;考勤规则")
@SaturnEntity(name = "SfaWorkSignRuleRespVo", description = "考勤规则;考勤规则")
public class SfaWorkSignRuleRespVo extends SfaWorkSignRuleVo {
    @ApiModelProperty("考勤规则-打卡人员")
    @SaturnColumn(description = "考勤规则-打卡人员")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSignPersonnelRespVo> sfaWorkSignPersonnelRespVo;
    @ApiModelProperty("考勤规则-打卡地点")
    @SaturnColumn(description = "考勤规则-打卡地点")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSignPlaceRespVo> sfaWorkSignPlaceRespVos;

    @ApiModelProperty("考勤规则-打卡时间")
    @SaturnColumn(description = "考勤规则-打卡时间")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSignTimeRespVo> sfaWorkSignTimeRespVos;

    @ApiModelProperty("考勤规则-特殊日期 必须打卡的日期")
    @SaturnColumn(description = "考勤规则-特殊日期")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialMustRespVos;

    @ApiModelProperty("考勤规则-特殊日期 不用打卡的日期")
    @SaturnColumn(description = "考勤规则-特殊日期")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialNotRespVos;
}