package com.biz.crm.nebular.tpm.actfieldcollect.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author zeyi
 * 活动采集字段表;请求vo
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmActCollectFieldReqVo", description = " 活动采集字段表;请求vo;")
public class TpmActCollectFieldReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("需要排除的字段编码集合")
    private List<String> excludeCodes;

    @ApiModelProperty("字段编码")
    private String fieldCode;

    @ApiModelProperty("字段名称")
    private String fieldName;

    @ApiModelProperty("数据字典")
    private String dataDict;

    @ApiModelProperty("输入类型")
    private String inputType;

    @ApiModelProperty("时间格式")
    private String timeFormat;

    @ApiModelProperty("字段可填大小")
    private String fieldInputSize;

    @ApiModelProperty("显示宽度")
    private String showWidth;

    @ApiModelProperty("显示高度")
    private String showHeight;

}