package com.biz.crm.nebular.activiti.listener.req;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 请求vo
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaListenerReqVo", description = "")
public class TaListenerReqVo extends PageVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("监听器方法")
    private String listenerEvent;

    @ApiModelProperty("监听器名称")
    private String listenerName;

    @ApiModelProperty("监听器状态，1-启用，2-禁用")
    private Integer listenerState;

    @ApiModelProperty("监听器类型-表达式- expression ,JAVA监听扩展类-javaClass")
    private String listenerType;

    @ApiModelProperty("监听器内容/类路径")
    private String listenerValue;

    @ApiModelProperty("监听类型ID,1-执行监听器，2-任务监听器")
    private Integer typeId;

    @ApiModelProperty("节点编码")
    private String nodeCode;

    @ApiModelProperty("流程版本key")
    private String processVersionKey;

}