package com.biz.crm.nebular.activiti.task.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author weston
 * @date 2020-12-23
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "CopyTaskReqVO", description = "抄送节点查询请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class CopyTaskReqVO extends PageVo {

    @ApiModelProperty(value = "用户编码")
    private String userCode;

    @ApiModelProperty(value = "用户岗位编码")
    private String positionCode;

    @ApiModelProperty(value = "节点状态(1=抄送2=已阅)")
    private Integer status;

    @ApiModelProperty(value = "业务类型")
    private String costType;

    @ApiModelProperty(value = "系统来源类型")
    private String formType;

    @ApiModelProperty(value = "业务细类")
    private String smallType;
}
