package com.biz.crm.nebular.activiti.task.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author weston
 * @date 2020-11-25
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "TaskOptReqVO", description = "任务节点操作请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class TaskOptReqVO {

    @ApiModelProperty(value = "操作用户岗位编码", required = true)
    private String positionCode;

    @ApiModelProperty(value = "任务节点ID", required = true)
    private String taskId;

    @ApiModelProperty(value = "流程实例ID", required = true)
    private String processInstanceId;

    @ApiModelProperty(value = "操作按钮编码", required = true)
    private String optBtn;

    @ApiModelProperty(value = "审批备注")
    private String remark;

    @ApiModelProperty(value = "下一节点(支持本次审批手动选择下一分支节点中的一个的场景)")
    private String nextTaskNode;

    @ApiModelProperty(value = "操作前表单快照HTML，驳回时可选参数")
    private String htmlUrl;
}
