package com.biz.crm.nebular.dms.feepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description: 费用池
 * @Author: zhangyuzhu
 * @Date: 2020/9/16 17:21
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "费用池主信息的vo")
@SaturnEntity(name = "FeePoolVo", description = "费用池主信息")
@SaturnDomain(value = "feepool")
public class FeePoolVo extends CrmExtVo {


    @ApiModelProperty(value = "编码")
    @SaturnColumn(description = "编码")
    private String code;

    @ApiModelProperty(value = "客户编码")
    @SaturnColumn(description = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "客户名称")
    @SaturnColumn(description = "客户名称")
    private String cusName;

    @ApiModelProperty(value = "客户所属组织编码")
    @SaturnColumn(description = "客户所属组织编码")
    private String cusOrgCode;

    @ApiModelProperty(value = "客户所属组织名称")
    @SaturnColumn(description = "客户所属组织名称")
    private String cusOrgName;

    @ApiModelProperty(value = "客户所属渠道编码")
    @SaturnColumn(description = "客户所属渠道编码")
    private String cusChannelCode;

    @ApiModelProperty(value = "客户所属渠道名称")
    @SaturnColumn(description = "客户所属渠道名称")
    private String cusChannelName;

    @ApiModelProperty(value = "费用池总额")
    @SaturnColumn(description = "费用池总额")
    private BigDecimal total;

    @ApiModelProperty(value = "费用池余额")
    @SaturnColumn(description = "费用池余额")
    private BigDecimal balance;

    /***/
    @ApiModelProperty(value = "详情")
    @SaturnColumn(description = "详情")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<FeePoolDetailVo> details;




    /**占位符  为niubela准备，这个字段不要用 属于detail的*/
    @ApiModelProperty(value = "支付方式")
    @SaturnColumn(description = "支付方式")
    private Integer payTypePlaceholder;

    /**占位符  为niubela准备，这个字段不要用 属于detail的*/
    @ApiModelProperty(value = "调整类型")
    @SaturnColumn(description = "调整类型")
    private Integer adjustmentTypePlaceholder;

    /**占位符  为niubela准备，这个字段不要用 属于detail的*/
    @ApiModelProperty(value = "产品")
    @SaturnColumn(description = "产品")
    private String productPlaceholder;

}
