package com.biz.crm.nebular.dms.promotion.policy.req;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * 促销政策订单明细请求vo
 *
 * @author lf
 * @date 2020-12-26 13:34:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DmsPromotionPolicyOrderDetailReqVo", description = "促销政策订单明细")
public class DmsPromotionPolicyOrderDetailReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("明细状态 locked:已锁定, commit:已提交, unlock:解除锁定, rollback:已回滚")
    private String policyOrderDetailStatus;

    @ApiModelProperty("促销政策id")
    private String promotionPolicyId;

    @ApiModelProperty("订单id")
    private String orderId;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("政策使用量")
    private BigDecimal usedQty;

    @ApiModelProperty("政策使用量类型 QTY_TYPE number:数量, amount:金额")
    private String usedQtyType;

    @ApiModelProperty("政策使用量单位 rmb:元, product_base_unit:基本单位, material_sale_unit:销售单位")
    private String usedQtyUnit;

    @ApiModelProperty("命中该政策的明细数据")
    private String hitDetail;

}