package com.biz.crm.nebular.dms.rebatefeepool;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用折扣汇总报表查询参数
 * @Author: chenrong
 * @Date: 2020/12/14 14:06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "费用折扣汇总报表查询参数")
public class RebateFeePoolSumReportReq {

  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String cusName;

  /**
   * 客户所属组织编码
   */
  @ApiModelProperty(value = "客户所属组织编码")
  private String cusOrgCode;

  /**
   * 客户所属组织名称
   */
  @ApiModelProperty(value = "客户所属组织名称")
  private String cusOrgName;

  /**
   * 销售公司编码
   */
  @ApiModelProperty(value = "销售公司编码")
  private String saleCompanyCode;

  /**
   * 销售公司名称
   */
  @ApiModelProperty(value = "销售公司名称")
  private String saleCompanyName;

  /**
   * 客户所属渠道编码
   */
  @ApiModelProperty(value = "客户所属渠道编码")
  private String cusChannelCode;

  /**
   * 客户所属渠道名称
   */
  @ApiModelProperty(value = "客户所属渠道名称")
  private String cusChannelName;

  /**
   * 开始日期，格式yyyy-MM-dd
   */
  @ApiModelProperty(value = "开始日期，格式yyyy-MM-dd")
  private String startDate;

  /**
   * 结束日期，格式yyyy-MM-dd
   */
  @ApiModelProperty(value = "结束日期，格式yyyy-MM-dd")
  private String endDate;
}
