package com.biz.crm.nebular.dms.repfeepool;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货补费用池文件
 * @Author: chenrong
 * @Date: 2020/11/25 21:47
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel("货补费用池文件")
public class RepFeePoolFileVo implements Serializable {

    private static final long serialVersionUID = 7071389313784507262L;

    //主键
    @ApiModelProperty("主键")
    private String id;

    //文件名字
    @ApiModelProperty("文件名字")
    private String fileName;

    //文件唯一标识
    @ApiModelProperty("文件唯一标识")
    private String objectName;

    //文件全路径
    @ApiModelProperty("文件全路径")
    private String url;

    //文件路径
    @ApiModelProperty("文件路径")
    private String urlPath;

    //域名
    @ApiModelProperty("域名")
    private String urlPathPrefix;

    //折扣费用池条目日志编码
    @ApiModelProperty("折扣费用池条目日志编码")
    private String rebateFeePoolDetailLogCode;
}
