package com.biz.crm.nebular.dms.repfeepool;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/24 16:30
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "货补费用池汇总vo")
public class RepItemReflushVo implements Serializable {

    /**
     * 上账数量
     */
    private BigDecimal onAccountCount = BigDecimal.ZERO;

    /**
     * 上账金额
     */
    private BigDecimal onAccountFee = BigDecimal.ZERO;

    /**
     * 已使用数量
     */
    private BigDecimal usedCount = BigDecimal.ZERO;

    /**
     * 已使用金额
     */
    private BigDecimal usedFee = BigDecimal.ZERO;

    /**
     * 冻结数量
     */
    private BigDecimal frozenCount = BigDecimal.ZERO;

    /**
     * 冻结金额
     */
    private BigDecimal frozenFee = BigDecimal.ZERO;

    /**
     * 可用数量
     */
    private BigDecimal availableCount = BigDecimal.ZERO;

    /**
     * 可用金额
     */
    private BigDecimal availableFee = BigDecimal.ZERO;



    /**
     * 待提交数量(add)
     */
    private BigDecimal toSubmitNum = BigDecimal.ZERO;

    /**
     * 待提交金额(add)
     */
    private BigDecimal toSubmitFee = BigDecimal.ZERO;

    /**
     * 待审核数量(add)
     */
    private BigDecimal toExamineNum = BigDecimal.ZERO;

    /**
     * 待审核金额(add)
     */
    private BigDecimal toExamineFee = BigDecimal.ZERO;

    /**
     * 金额
     */
    private BigDecimal fee;

    /**
     * 数量
     */
    private BigDecimal num;

    /**
     * 审核状态
     */
    private Integer bpmState;
}
