package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/2 15:40
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "根据职位信息查询人区信息的vo")
@SaturnEntity(name = "ListByPosVo", description = "根据职位信息查询人区信息的vo")
public class ListByPosVo extends PageVo {

    @ApiModelProperty(value = "职位id")
    @SaturnColumn(description = "职位id")
    private String posId;

    @ApiModelProperty(value = "职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty(value = "职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty(value = "组织id")
    @SaturnColumn(description = "组织id")
    private String orgId;

    @ApiModelProperty(value = "组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty(value = "组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty(value = "组织描述")
    @SaturnColumn(description = "组织描述")
    private String orgDesc;

    @ApiModelProperty(value = "用户id")
    @SaturnColumn(description = "用户id")
    private String userId;

    @ApiModelProperty(value = "用户账号")
    @SaturnColumn(description = "用户账号")
    private String userAccount;

    @ApiModelProperty(value = "用户名称")
    @SaturnColumn(description = "用户名称")
    private String userName;
}
