package com.biz.crm.nebular.mdm.humanarea;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 组织-客户关联：修改组织编码入参
 *
 * @author zxw
 * @date 2020-10-09 18:51
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmOrgCustomerUpdateReqVo", description = "组织-客户关联：修改组织编码入参")
public class MdmOrgCustomerUpdateReqVo {

    @ApiModelProperty("组织编码")
    @NotBlank(message = "组织编码不能为空")
    private String orgCode;

    @ApiModelProperty("客户编码集合")
    @NotEmpty(message = "客户编码集合不能为空")
    private List<String> customerCodeList;
}
