package com.biz.crm.nebular.mdm.pricesetting.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * 价格查询入参
 *
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPriceSearchReqVo", description = "价格查询入参 ")
public class MdmPriceSearchReqVo extends CrmExtVo {

    @ApiModelProperty("时间,精确年月日，格式yyyy-MM-dd")
    private String searchTime;

    @ApiModelProperty("商品编码集合")
    private List<String> productCodeList;

    @ApiModelProperty("条件类型编码集合")
    private List<String> conditionTypeCodeList;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("销售公司编码")
    private String saleCompanyCode;

}