package com.biz.crm.nebular.mdm.product.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 返回vo
 *
 * @author crm
 * @date 2020-08-27 16:29:11
 */
@ApiModel(value = "商品图片")
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@SaturnEntity(name = "MdmProductPictureRespVo", description = "商品图片信息")
public class MdmProductMediaRespVo implements Serializable {
    @ApiModelProperty("地址")
    @SaturnColumn(description = "链接地址")
    private String urlAddress;

    @ApiModelProperty("商品编码")
    @SaturnColumn(description = "商品编码")
    private String productCode;

    @ApiModelProperty("排序位置")
    @SaturnColumn(description = "排序位置")
    private Integer rangeNum;

    @ApiModelProperty("文件类型('picture'图片,'video'视频)")
    @SaturnColumn(description = "文件类型")
    private String type;

    @SaturnColumn(description = "文件名称")
    @ApiModelProperty("文件名称")
    private String fileName;

    @SaturnColumn(description = "源文件名称")
    @ApiModelProperty("源文件名称")
    private String originalFileName;

    @SaturnColumn(description = "目录")
    @ApiModelProperty("目录")
    private String relativeLocal;

//    @SaturnColumn(description = "基本信息")
//    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.ManyToOne)
//    private MdmProductRespVo productRespVo;

}