package com.biz.crm.nebular.sfa.clientsellpower.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 经销商/终端产品经销权可购商品 返回vo
 *
 * @author liuhongming
 * @date 2020-09-24 14:13:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "经销商/终端产品经销权可购商品 ")
@SaturnEntity(name = "SfaClientSellProductRespVo", description = "经销商/终端产品经销权可购商品 ")
public class SfaClientSellProductRespVo extends CrmExtVo {
    @ApiModelProperty("产品编码 产品编码")
    @SaturnColumn(description = "产品编码 产品编码")
    private String productCode;

    @ApiModelProperty("产品名称 产品名称")
    @SaturnColumn(description = "产品名称 产品名称")
    private String productName;

    @ApiModelProperty("产品层级编码 产品层级编码")
    @SaturnColumn(description = "产品层级编码 产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称 产品层级名称")
    @SaturnColumn(description = "产品层级名称 产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品规格 产品规格")
    @SaturnColumn(description = "产品规格 产品规格")
    private String specifications;

    @ApiModelProperty("经销权编码 经销权编码")
    @SaturnColumn(description = "经销权编码 经销权编码")
    private String tspCode;

}