package com.biz.crm.nebular.sfa.worksign.form.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author ren.gang
 * @ClassName SfaWorkOvertimeDetailRespVo.java
 * @Description 工作日调整申请明细返回vo
 * @createTime 2020年12月01日 15:14:00
 */
@Data
@ApiModel("工作日调整申请明细返回vo")
public class SfaWorkOvertimeDetailRespVo {

    private String id;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("区域")
    private String parentOrgName;

    @ApiModelProperty("办事处")
    private String orgName;

    @ApiModelProperty("工作日调整类型(1普通调整，2节假日调整)")
    private String overtimeType;

    @ApiModelProperty("申请原因")
    private String overtimeReason;

    @ApiModelProperty("申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    @ApiModelProperty("开始时间 开始时间(yyyy-MM-dd HH)")
    private String beginTime;

    @ApiModelProperty("结束时间 结束时间(yyyy-MM-dd HH)")
    private String endTime;

    @ApiModelProperty("审批状态 审批状态")
    private String bpmStatus;

    @ApiModelProperty("审批状态说明")
    private String bpmStatusDesc;

    @ApiModelProperty("日期明细json")
    private String timeInfoListJson;

    @ApiModelProperty("申请时长(天)")
    private String overtimeDuration;

    @ApiModelProperty("审核任务id")
    private String auditTaskId;

}
