package com.biz.crm.nebular.tpm.advancepay.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayDetailRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 活动预付主表 请求vo
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmActAdvancePayReqVo", description = "活动预付主表 ")
public class TpmActAdvancePayReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动预付类型")
    private String advanceType;

    @ApiModelProperty("预付编号")
    private String advanceCode;

    @ApiModelProperty("审批状态")
    private String approveStatus;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("客户所属组织(企业组织)")
    private String customerOrgCode;

    @ApiModelProperty("客户所属组织名称")
    private String customerOrgName;

    @ApiModelProperty("申请预付总金额")
    private BigDecimal applyAdvanceTotalAmount;

    @ApiModelProperty("已预付总金额")
    private BigDecimal actualAdvancePayTotalAmount;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("活动预付明细")
    private List<TpmActAdvancePayDetailReqVo> detailVos;

    @ApiModelProperty("保存类型:1新增暂存,2,新增并提交审批,3,修改暂存,4修改并提交审批,5,提交审批")
    private String saveType;

    @ApiModelProperty("主题")
    private String title;

    @ApiModelProperty("审批备注")
    private String approveRemarks;

}