package com.biz.crm.nebular.activiti.act.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author weston
 * @date 2020-12-23
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "ProcessCopyReqVO", description = "流程抄送配置请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class ProcessCopyReqVO {

    @ApiModelProperty(value = "流程KEY", required = true)
    private String processKey;

    @ApiModelProperty(value = "抄送目标用户", required = true)
    private List<CopyToUserReqVO> users;
}
