package com.biz.crm.nebular.mdm.common;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 懒加载树返回VO
 *
 * @author Tao.Chen
 * @date 2020-12-14 17:12:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BaseTreeRespVo")
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class BaseLazyTreeRespVo {

    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("上级code")
    private String parentCode;

    @ApiModelProperty("是否有下级")
    private Boolean hasChild;

    @ApiModelProperty("下级")
    private List<BaseLazyTreeRespVo> children;

}
