package com.biz.crm.nebular.mdm.mqlog;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
@ApiModel(value = "MdmMqMessageLogVo", description = "mq消息日志")
public class MdmMqMessageLogVo extends CrmTreeVo {
    public static final String SUCCESS = "SUCCESS";

    /**
     * topic
     */
    @ApiModelProperty("topic")
    private String topic;

    /**
     * 消息业务key,选传
     */
    @ApiModelProperty("消息业务key,选传")
    private String bizKey;

    /**
     * 消息体
     */
    @ApiModelProperty("消息体")
    private String msgBody;

    /**
     * 该消息消费成功后，需执行的回调
     */
    @ApiModelProperty("该消息消费成功后，需执行的回调")
    private String callbackFeignBeanName;
    /**
     * 发送日志
     */
    @ApiModelProperty("发送日志")
    private String sendLog;

    /**
     * 回调日志
     */
    @ApiModelProperty("回调日志")
    private String callbackLog;


}
